#!/usr/bin/env bash

#set -x
set -e

function MakeTheoryExptVcd()
{
local SaveDir SaveBase Save
if [ -n "$MikeThesis" ]; then
  SaveDir="$MikeThesis/ScriptPlots/"
  mkdir -p "$SaveDir"
fi
SaveBase="${SaveBase:-ConclusionVcd}"
Save="$SaveDir$SaveBase"
gnuplot <<-EOFMark

PDFSize="size ${size:-4in,4in}"
Save="$Save"

ResultFPlusQMax=1.592
ErrFPlusQMax=0.023184354

\$fPlusQMax << EndOfData
#Val Error series
1 1.592 0.023184354 'This thesis' 1


2 1.576 0.016 'Fermilab/MILC' 2
#0.72 0.085 'BESIII' 3
EndOfData

ResultFZeroQMax=1.000
ErrFZeroQMax=0.012189165

\$fZeroQMax << EndOfData
#Val Error series
1 1.000 0.012189165 'This thesis' 1


2 0.9843 0.0030 'Fermilab/MILC' 2
#0.72 0.085 'BESIII' 3
EndOfData

ResultFZeroQZero=0.6557
ErrFZeroQZero=0.007815361

\$fZero << EndOfData
#Val Error series
1 0.6557 0.007815361 'This thesis' 1


2 0.6307 0.0029 'Fermilab/MILC' 2


0 0.72 0.085 'BESIII' 3
EndOfData

set term tikz standalone @PDFSize font '\\small' header '\\usepackage{physics}'
set output Save.'.tex'

set multiplot layout 3,1 margins 0.1,1,0.08,1 spacing 0.025

set linetype 1 linecolor 7 pointtype 7
set linetype 2 linecolor 6 pointtype 7
set linetype 3 linecolor 8 pointtype 7
set pointintervalbox 0
set xrange [-0.5:2.5]
unset xtics

# F0(q_max)
set yrange [1.555:1.63]
set ylabel '\$f_+ \left( q^2_\textrm{max} \right)$'

set object 1 rect from graph 0, first ResultFPlusQMax-ErrFPlusQMax to graph 1, first ResultFPlusQMax+ErrFPlusQMax \
    fc "red" fs transparent solid 0.1 noborder

plot for [IDX=0:2] \$fPlusQMax index IDX using 1:2:3 with yerrorbars notitle linetype IDX+1
unset yrange

# F+(q_max)
unset xlabel
set ylabel '\$f_0 \left( q^2_\textrm{max} \right)$'
set ytics 0.01

set object 1 rect from graph 0, first ResultFZeroQMax-ErrFZeroQMax to graph 1, first ResultFZeroQMax+ErrFZeroQMax \
    fc "red" fs transparent solid 0.1 noborder

plot for [IDX=0:2] \$fZeroQMax index IDX using 1:2:3 with yerrorbars notitle linetype IDX+1

# F0(0)=F+(0)
set yrange [0.625:0.81]
set xtics out nomirror ('BESIII' 0, 'This thesis' 1, 'Fermilab/MILC' 2)
#set xlabel 'ylabel'
set ylabel '\$f_0 \left( 0 \right)$'
set ytics 0.05
set linetype 2 pointsize 0.6

set object 2 rect from graph 0, first 0.635 to graph 1, first 0.805 \
    fs transparent solid 0.5 noborder fc rgb 0xD0D0D0 behind
set object 1 rect from graph 0, first ResultFZeroQZero-ErrFZeroQZero to graph 1, first ResultFZeroQZero+ErrFZeroQZero \
    fc "red" fs transparent solid 0.1 noborder

plot for [IDX=0:2] \$fZero index IDX using 1:2:3 with yerrorbars notitle linetype IDX+1
#set xlabel 'xlabel'
#plot cos(2*x)
unset multiplot

set output

EOFMark

(
  cd "$SaveDir"
  pdflatex "$SaveBase" && rm "$SaveBase".{log,aux}
)
}

MakeTheoryExptVcd
