#!/usr/bin/env bash

. PlotCommon.sh NoPreamble

#set -x

Ensembles="${Ensembles:-$(echo C{1,2} M{1,2,3} F1M)}"
Series="${Series:-renorm}"

# Assumes $PWD is NoSync
NoSync=$PWD
MikeThesis=$(dirname $(readlink -f R $0)); MikeThesis=${MikeThesis%/Scripts}
PlotLinks=$NoSync/ThesisLinks/R3
mkdir -p $PlotLinks

function HumanNumber()
{
  local i
  local Input="$2"
  local -n Result=${1:-hNumber}
  Result=
  for((i=0;i<${#Input};++i))
  do
    case "${Input:i:1}" in
      0) Result+=Zero;;
      1) Result+=One;;
      2) Result+=Two;;
      3) Result+=Three;;
      4) Result+=Four;;
      5) Result+=Five;;
      6) Result+=Six;;
      7) Result+=Seven;;
      8) Result+=Eight;;
      9) Result+=Nine;;
      *) Result+="${Input:i:1}";;
    esac
  done
}

function HumanAnd()
{
  local -n Result=${1:-AndString}
  shift
  local i
  local n=$#
  Result=''
  for((i=1;i<=n;++i))
  do
    if ((i!=1)); then
      if ((i==n)); then
          Result+=' and '
      else
          Result+=', '
      fi
    fi
    Result+="$1"
    shift
  done
}

function MakeLink()
{
local Dest="$1"
local Source="$2"
local Extra="$3"
local Suffix="${Source##*.model}"
local Prefix="${Source%$Suffix}"
      Suffix="${Suffix%h5}pdf"
if [ -e "$Dest" ] || [ -h "$Dest" ]; then rm "$Dest"; fi
ln -s "$Prefix$Extra$Suffix" "$Dest"
}

function MakeTwoPtTable_K()
{
  local n
  local NumNSq=$((NumRows/4))
  local sTimes
  for ((n=0;n<${#FitTimes[@]};++n)); do
    if [ -n "$sTimes" ]; then
      if ((n==${#FitTimes[@]}-1)); then
        sTimes+=' and '
      else
        sTimes+=', '
      fi
    fi
    sTimes+="${FitTimes[n]} (\$n^2=$n\$)"
  done
  echo "\\def\\ValRatio${EnsCode}${Meson}times{$sTimes}"
  echo '\centering'
  echo '\begin{tabular}{clllll}'
  echo '\toprule'
  echo '$n^2$ & $a E_0$ & $a E_1$ & $A_{\textrm{P},0}$ & $A_{\textrm{P},1}$ & $t$-fit \\'
  for((n=0;n<NumNSq;++n))
  do
    echo "$n & ${Columns[(n*4)*8+1]} & ${Columns[(n*4+1)*8+1]} & ${Columns[(n*4+2)*8+1]} & ${Columns[(n*4+3)*8+1]} & ${FitTimes[n]}"' \\'
  done
  echo '\bottomrule'
  echo '\end{tabular}'
}

function MakeTwoPtTable_Ds()
{
  local i
  local NumW=$((NumRows - 4))
  local ColSpec='lll|lll|l'
  local Fields='$p$-val & $a m_0$ & $a m_1$ & $t_{\textrm{P}}$-fit & $A_{\textrm{P},0}$ & $A_{\textrm{P},1}$ & $t_{\textrm{W}}$-fit'
  local Values="$pValueH & ${Columns[1]} & ${Columns[9]} & ${FitTimes[0]} & ${Columns[17]} & ${Columns[25]} & ${FitTimes[1]}"
  echo "\\def\\ValRatio${EnsCode}${Meson}tP{${FitTimes[0]}}"
  echo "\\def\\ValRatio${EnsCode}${Meson}tW{${FitTimes[1]}}"
  echo "\\def\\ValRatio${EnsCode}${Meson}NumW{$NumW}"
  for((i=0;i<NumW;++i)); do
    ColSpec+=l
    Fields+=' & $A_{\textrm{W},'"$i"'}$'
    Values+=" & ${Columns[(i+4)*8+1]}"
  done
  echo '\centering'
  echo '\begin{tabular}{'"$ColSpec}"
  echo '\toprule'
  echo "$Fields"' \\'
  echo "$Values"' \\'
  echo '\bottomrule'
  echo '\end{tabular}'
}

function DoTwoPt()
{
  local TwoPtFit="$1"
  local i File Base BaseParts Dest FileList Meson FitTimes Columns NumRows pValueH FileTwo
  local FileRaw=$(h5dump -d /model/FileList "$TwoPtFit" | grep : | cut -w -f 3-)
  eval FileList=(${FileRaw//,}) # Array without trailing comma and surrounding quotes
  if ((${#FileList[@]} > 1)); then
    for((i=-2;i<0;++i)); do
      File=${FileList[i]}
      Base=${File##*/}
      Base=${Base%%.*}
      BaseParts=(${Base//_/ })
      if((${#BaseParts[@]}>1)); then
        Meson=${BaseParts[0]:0:1}_${BaseParts[1]:0:1}
        case "$Meson" in
          s_l) Meson=K;;
          h_s) Meson=Ds;;
        esac
        Dest="$PlotLinks/${Ensemble}_$Meson"
        MakeLink "$Dest.pdf" "$NoSync/$File" _log
        FileTwo="../../../$File"
        unset FitTimes
        GetFitTimes "$FileTwo" FitTimes
        FitTimes=($FitTimes)
        Columns=($(GetColumn "$FileTwo"))
        NumRows=$((${#Columns[@]}/8-3))
        pValueH=${Columns[(NumRows+2)*8+1]%(*}
        {
          echo "\\def\\ValRatio${EnsCode}${Meson}PH{$pValueH}"
          eval MakeTwoPtTable_$Meson
        } > "$Dest.tex"
      fi
    done
  fi
}

function WriteMELDef()
{
  local Idx Gamma P WallSep FitTimes
  local -a IdxParts

  local Cols=$((${#Columns[@]} / 8 - 1))
  echo "% Ensemble: $Ensemble"
  echo "% Series: $Series"
  #echo "\\def\\ValRatio${EnsCode}${MesonSrc}Human{$MesonSrcHuman}"
  #echo "\\def\\ValRatio${EnsCode}${MesonSnk}Human{$MesonSnkHuman}"
  for Idx in "${!AWallSep[@]}"
  do
    IdxParts=(${Idx//_/ })
    Gamma=${IdxParts[0]}
    HumanNumber P "${IdxParts[1]}"
    HumanAnd WallSep ${AWallSep[$Idx]//_/ }
    echo "\\def\\ValRatio${EnsCode}${MesonSnk}${MesonSrc}WallSep${Gamma}${P}{$WallSep}"
    HumanAnd FitTimes ${AFitTimes[$Idx]}
    echo "\\def\\ValRatio${EnsCode}${MesonSnk}${MesonSrc}FitTimes${Gamma}${P}{$FitTimes}"
    echo "\\def\\ValRatio${EnsCode}${MesonSnk}${MesonSrc}PValueH${Gamma}${P}{${Results[$Idx]%% *}}"
    echo "\\def\\ValRatio${EnsCode}${MesonSnk}${MesonSrc}MEL${Gamma}${P}{${AMEL[$Idx]}}"
  done
}

function WriteMELTable()
{
  local i sT si Row
  local FieldAlignT=l
  local FieldAligni=l
  local Cols=$((${#Columns[@]} / 8 - 1))
  local Excited=(gnd-gnd gnd-ex ex-gnd ex-ex)
  for((i=0;i<Cols;++i)); do
    sT+=" & ${Excited[i]}"
    si+=" & ${Excited[i]}"
    FieldAlignT+='l'
    FieldAligni+='l'
  done
  echo '\begin{table}[H]'
  echo '\RatioFitEnsTextSize'
  #echo '\tiny'
  echo '\centering'
  echo '\begin{tabular}{'c"|${FieldAlignT}|${FieldAligni}"'}'
  echo '\toprule'
  echo ' & \multicolumn{'"$((Cols+1))"'}{c|}{$\mel{K}{\gamma_4}{D_s}$} & \multicolumn{'"$((Cols+1))"'}{c}{$\mel{K}{\gamma_i}{D_s}$}\\'
  echo '$n^2$ & $p$'"$sT"' & $p$'"$si"'\\'
  echo '\midrule'

  for((i=0;i<=pMax;++i))
  do
    Row="$i & ${Results['gT_'$i]}"
    ((i)) && Row+=" & ${Results['gXYZ_'$i]}"
    echo "$Row"' \\'
  done
  echo '\bottomrule'
  echo '\end{tabular}'
}

function DoEnsemble()
{
  local Spec=s
  local Dir="$Ensemble/MELFit/3sm_${Spec}p2"
  if [ -d "$Dir" ]
  then
    (
    declare -a Columns
    declare -A Results AWallSep AFitTimes AMEL
    MesonSnk=K
    MesonSrc=Ds
    MesonSnkHuman=kaon
    MesonSrcHuman='$D_s$'
    pMax=-1
    cd "$Dir"
    Source="$PWD"
    for File in R3_l_h*_p2_*.dt_*."$Series".corr_*.h5
    do
      FileParts=(${File//./ })
      BaseParts=(${FileParts[0]//_/ })
      qSrc="${BaseParts[2]}"
      if (("${#BaseParts[@]}" < 6)) || [ "${BaseParts[0]}" != R3 ] \
      || [ "${BaseParts[1]}" != l ] || [ "${qSrc:0:1}" != h ] \
      || [ "${BaseParts[4]}" != p2 ] || [ "${FileParts[1]%%_*}" != dt ] ; then
        echo "Unrecognised: $Ensemble $File"
      else
        p=${BaseParts[5]}
        gamma=${BaseParts[3]}
        Prefix=$PlotLinks/${Ensemble}_K_Ds_${gamma}_p2_${p}
        MakeLink "${Prefix}.pdf" "$Source/$File" _corr
        if ((p==0)) && [ "$gamma" == gT ]; then DoTwoPt $File; fi
        # Now save the fit data for this row
        ((pMax<p)) && pMax=p
        Columns=($(GetColumn --partial pvalueH,MEL $File))
        # Chop the brackets off the p-value
        Tmp="${Columns[1]}"
        Tmp="${Tmp%%(*}"
        for((i=9; i<${#Columns[@]}; i+=8)); do
          Tmp+=" & ${Columns[i]}"
        done
        Results[${gamma}_$p]="$Tmp"
        AWallSep[${gamma}_$p]="${FileParts[1]#dt_}"
        GetFitTimes "$File" FitTimes
        AFitTimes[${gamma}_$p]="$FitTimes"
        AMEL[${gamma}_$p]="${Columns[9]}"
      fi
    done
    WriteMELDef   > "$PlotLinks/${Ensemble}_def.tex"
    WriteMELTable > "$PlotLinks/${Ensemble}_table.tex"
    )
  fi
}

echo "Replotting ratios $Ensembles"
for Ensemble in $Ensembles
do
  case "${Ensemble:1:1}" in
    1) EnsCode="One";;
    2) EnsCode="Two";;
    3) EnsCode="Three";;
    *) EnsCode="${Ensemble:1:1}";;
  esac
  EnsCode="${Ensemble:0:1}$EnsCode${Ensemble:2}"
  #echo -e "----------\n$Ensemble"
  DoEnsemble &
done
wait

echo -e "----------\nTo update plots:"
echo 'for E in '"$Ensembles"'; do PlotOnly= DoAll= DoDisp= FitTwoPoint$E.sh; ' \
    'PlotOnly=NoAlt series='"'$Series'"' FitMEL$E.sh; done'
