#!/usr/bin/env bash

. PlotCommon.sh NoPreamble

Ensembles="${Ensembles:-$(echo C{1,2} M{1,2,3} F1M)}"
Series="${series:-renorm}"

# Assumes $PWD is NoSync
PlotLinks='ThesisLinks/FF/'
mkdir -p "$PlotLinks"
Summary="$PlotLinks/FFSummary_$Series"

function WriteGlobal()
{
  local Ensemble EnsCode
  # Write header
  echo '\begin{table}[H]'
  #echo '\smaller'
  echo '\centering'
  echo '\hspace{-1cm}'
  echo '\begin{tabular}{cll}'
  echo '\toprule'
  echo 'Name & $a m_{D_s}$ & $Z_{V, \textrm{m}}$ \\'
  echo '\midrule'
  for Ensemble in $Ensembles
  do
    ConvertDigits "$Ensemble"
    echo "$Ensemble & ${Global[${Ensemble}'_mH']} & ${Global[${Ensemble}'_ZV']}"' \\'
  done
  # Write footer
  echo '\bottomrule'
  echo '\end{tabular}'
}

function WriteEnsemble()
{
  local EnsCode n Key MELVi fPerp
  # Write declarations
  ConvertDigits "$Ensemble"
  # Write header
  echo '\begin{table}[H]'
  echo '\tiny'
  #echo '\centering'
  #echo '\hspace{-1cm}'
  echo '\begin{tabular}{cllllllll}'
  echo '\toprule'
  echo '$n^2$ & $a E_K$ & $\lr{a q}^2$ & $\mel{K}{\mathcal{V}_4}{D_s}$ & $\mel{K}{\mathcal{V}_i}{D_s}$ & $f_{\parallel} \sqrt{a}$ & $\flatfrac{f_{\perp}}{\sqrt{a}}$ & $f_0$ & $f_+$ \\'
  echo '\midrule'
  # Now write data for each n^2
  for (( n=0; n<=nMax; ++n ))
  do
    Key=${n}'_'
    if ((n==0)); then
      unset MELVi
      unset fPerp
    else
      MELVi="${Value[${Key}'melVi']}"
      fPerp="${Value[${Key}'fPerp']}"
    fi
    echo "$n & ${Value[${Key}'EL']} & ${Value[${Key}'qSq']} & ${Value[${Key}'melV0']} & $MELVi & ${Value[${Key}'fPar']} & $fPerp & ${Value[${Key}'f0']} & ${Value[${Key}'fPlus']}"' \\'
  done
  # Write footer
  echo '\bottomrule'
  echo '\end{tabular}'
}

function ParseEnsemble()
{
  # Get ZV_mixed before I cd
  local -A Value
  local -a aCol BaseParts
  local File Base n Key i
  local nMax=-1
  local InDir="$Ensemble/FormFactor/$Series/3sm_sp2/"
  for File in "${InDir}"F3_l_h*_p2_*.model.*.h5
  do
    Base="${File##*/}"
    Base="${Base%%.*}"
    BaseParts=(${Base//_/ })
    if (( ${#BaseParts[@]} < 5 )); then
      echo "  Unrecognised file \"$File\""
    else
      n=${BaseParts[4]}
      echo "  $Ensemble $n $File"
      (( nMax < n )) && nMax=$n
      Key=${n}_
      # Get all the values we're interested in
      aCol=($(GetColumn "$File"))
      for (( i=0; i<${#aCol[@]}; i+=8 ))
      do
        Value[${Key}${aCol[i]}]="${aCol[i+1]}"
      done
    fi
  done
  WriteEnsemble > "${Summary}_${Ensemble}.tex"
  # Now pop a few things in the global table to write at the end
  i=${Ensemble}_
  for Key in mH ZV
  do
    Global[$i$Key]="${Value['0_'$Key]}"
  done
}

############################################################

# Main loop

############################################################

# Write each row
declare -A Global
for Ensemble in $Ensembles
do
  echo -e "----------\n$Ensemble"
  ParseEnsemble
done
WriteGlobal > "${Summary}.tex"
